/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.support.ParsedSql;

public class NamedParameterUtils {
    private static final int MAX_SELECT_LIST_ENTRIES = 100;
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$jdbc$support$NamedParameterUtils == null ? (class$org$springframework$jdbc$support$NamedParameterUtils = NamedParameterUtils.class$("org.springframework.jdbc.support.NamedParameterUtils")) : class$org$springframework$jdbc$support$NamedParameterUtils));
    static /* synthetic */ Class class$org$springframework$jdbc$support$NamedParameterUtils;

    public static int countParameterPlaceholders(String sql) {
        byte[] statement = sql == null ? new byte[]{} : sql.getBytes();
        boolean withinQuotes = false;
        ArrayList<String> namedParameters = new ArrayList<String>();
        int currentQuote = 45;
        int parameterCount = 0;
        for (int i = 0; i < statement.length; ++i) {
            if (withinQuotes) {
                if (statement[i] != currentQuote) continue;
                withinQuotes = false;
                currentQuote = 45;
                continue;
            }
            if (statement[i] == 34 || statement[i] == 39) {
                withinQuotes = true;
                currentQuote = (char)statement[i];
                continue;
            }
            if (statement[i] == 58 || statement[i] == 38) {
                int j;
                StringBuffer parameter = new StringBuffer();
                for (j = i + 1; j < statement.length && NamedParameterUtils.parameterNameIsContinued(statement, j); ++j) {
                    parameter.append(statement[j]);
                }
                if (j - i <= 1 || namedParameters.contains(parameter.toString())) continue;
                ++parameterCount;
                namedParameters.add(parameter.toString());
                i = j - 1;
                continue;
            }
            if (statement[i] != 63) continue;
            ++parameterCount;
        }
        return parameterCount;
    }

    public static ParsedSql parseSqlStatement(String sql) {
        ArrayList<String> namedParameters = new ArrayList<String>();
        ParsedSql parsedSql = new ParsedSql(sql);
        byte[] statement = sql == null ? new byte[]{} : sql.getBytes();
        StringBuffer newSql = new StringBuffer();
        boolean withinQuotes = false;
        int currentQuote = 45;
        int parameterCount = 0;
        int namedParameterCount = 0;
        for (int i = 0; i < statement.length; ++i) {
            if (withinQuotes) {
                if (statement[i] == currentQuote) {
                    withinQuotes = false;
                    currentQuote = 45;
                }
                newSql.append((char)statement[i]);
                continue;
            }
            if (statement[i] == 34 || statement[i] == 39) {
                withinQuotes = true;
                currentQuote = (char)statement[i];
                newSql.append((char)statement[i]);
                continue;
            }
            if (statement[i] == 58 || statement[i] == 38) {
                int j;
                for (j = i + 1; j < statement.length && NamedParameterUtils.parameterNameIsContinued(statement, j); ++j) {
                }
                if (j - i > 1) {
                    String parameter = sql.substring(i + 1, j);
                    namedParameters.add(parameter);
                    newSql.append("?");
                    ++parameterCount;
                    ++namedParameterCount;
                }
                i = j - 1;
                continue;
            }
            newSql.append((char)statement[i]);
            if (statement[i] != 63) continue;
            ++parameterCount;
        }
        parsedSql.setNamedParameterCount(namedParameterCount);
        parsedSql.setParameterCount(parameterCount);
        parsedSql.setNewSql(newSql.toString());
        parsedSql.setNamedParameters(namedParameters);
        System.out.println("->" + parsedSql.getNewSql());
        return parsedSql;
    }

    public static String substituteNamedParameters(String sql, Map argMap) {
        byte[] statement = sql == null ? new byte[]{} : sql.getBytes();
        StringBuffer newSql = new StringBuffer();
        boolean withinQuotes = false;
        int currentQuote = 45;
        for (int i = 0; i < statement.length; ++i) {
            if (withinQuotes) {
                if (statement[i] == currentQuote) {
                    withinQuotes = false;
                    currentQuote = 45;
                }
                newSql.append((char)statement[i]);
                continue;
            }
            if (statement[i] == 34 || statement[i] == 39) {
                withinQuotes = true;
                currentQuote = (char)statement[i];
                newSql.append((char)statement[i]);
                continue;
            }
            if (statement[i] == 58 || statement[i] == 38) {
                int j;
                for (j = i + 1; j < statement.length && NamedParameterUtils.parameterNameIsContinued(statement, j); ++j) {
                }
                if (j - i > 1) {
                    String parameter = sql.substring(i + 1, j);
                    if (argMap != null) {
                        Object o = argMap.get(parameter);
                        if (o instanceof List) {
                            if (((List)o).size() > 100) {
                                logger.warn((Object)"The number of entries in a select list should not exceed 100");
                            }
                            for (int k = 0; k < ((List)o).size(); ++k) {
                                if (k > 0) {
                                    newSql.append(", ");
                                }
                                newSql.append("?");
                            }
                        } else {
                            newSql.append("?");
                        }
                    } else {
                        newSql.append("?");
                    }
                }
                i = j - 1;
                continue;
            }
            newSql.append((char)statement[i]);
        }
        System.out.println("=>" + newSql.toString());
        return newSql.toString();
    }

    private static boolean parameterNameIsContinued(byte[] statement, int j) {
        return statement[j] != 32 && statement[j] != 44 && statement[j] != 41 && statement[j] != 34 && statement[j] != 39 && statement[j] != 124 && statement[j] != 59 && statement[j] != 10 && statement[j] != 13;
    }

    public static Object[] convertArgMapToArray(String sql, Map argMap) {
        ParsedSql parsedSql = NamedParameterUtils.parseSqlStatement(sql);
        return NamedParameterUtils.convertArgMapToArray(argMap, parsedSql);
    }

    public static Object[] convertArgMapToArray(Map parameters, ParsedSql parsedSql) {
        Object[] args = new Object[parsedSql.getNamedParameterCount()];
        if (parsedSql.getNamedParameterCount() != parsedSql.getParameterCount()) {
            throw new InvalidDataAccessApiUsageException("You must supply named parameter placeholders for all parameters when using a Map for the parameter values");
        }
        if (parsedSql.getNamedParameterCount() != parameters.size()) {
            if (parsedSql.getNamedParameterCount() > parameters.size()) {
                throw new InvalidDataAccessApiUsageException("Wrong number of parameters/values supplied. You have " + parsedSql.getNamedParameterCount() + " named parameter(s) and supplied " + parameters.size() + " parameter value(s)");
            }
            logger.warn((Object)("You have additional entries in the parameter map supplied. There are " + parsedSql.getNamedParameterCount() + " named parameter(s) and " + parameters.size() + " parameter value(s)"));
        }
        for (int i = 0; i < parsedSql.getNamedParameters().size(); ++i) {
            if (!parameters.containsKey(parsedSql.getNamedParameters().get(i))) {
                throw new InvalidDataAccessApiUsageException("No entry supplied for the '" + parsedSql.getNamedParameters().get(i) + "' parameter");
            }
            args[i] = parameters.get(parsedSql.getNamedParameters().get(i));
        }
        return args;
    }

    public static int[] convertTypeMapToArray(Map typeMap, ParsedSql parsedSql) {
        int[] types = new int[parsedSql.getNamedParameterCount()];
        if (parsedSql.getNamedParameterCount() != typeMap.size() && parsedSql.getNamedParameterCount() < typeMap.size()) {
            logger.warn((Object)("You have additional entries in the type map supplied.  There are " + parsedSql.getNamedParameterCount() + " named parameter(s) and " + typeMap.size() + " type value(s)"));
        }
        for (int i = 0; i < parsedSql.getNamedParameters().size(); ++i) {
            types[i] = typeMap.containsKey(parsedSql.getNamedParameters().get(i)) ? (Integer)typeMap.get(parsedSql.getNamedParameters().get(i)) : Integer.MIN_VALUE;
        }
        return types;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

