/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.luna;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseInternalFrameTitlePane;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JInternalFrame;

public class LunaInternalFrameTitlePane
extends BaseInternalFrameTitlePane {
    private static final Color FRAME_COLOR = new Color(0, 25, 207);

    public LunaInternalFrameTitlePane(JInternalFrame f) {
        super(f);
    }

    @Override
    protected int getHorSpacing() {
        return 2;
    }

    @Override
    protected int getVerSpacing() {
        return 5;
    }

    @Override
    public void paintText(Graphics g, int x, int y, String title) {
        if (this.isActive()) {
            g.setColor(ColorHelper.brighter(AbstractLookAndFeel.getTheme().getWindowBorderColor(), 10.0));
            JTattooUtilities.drawString(this.frame, g, title, x - 1, y - 2);
            g.setColor(ColorHelper.darker(AbstractLookAndFeel.getTheme().getWindowBorderColor(), 25.0));
            JTattooUtilities.drawString(this.frame, g, title, x + 1, y);
            g.setColor(AbstractLookAndFeel.getWindowTitleForegroundColor());
        } else {
            g.setColor(AbstractLookAndFeel.getWindowInactiveTitleForegroundColor());
        }
        JTattooUtilities.drawString(this.frame, g, title, x, y - 1);
    }

    @Override
    public void paintBorder(Graphics g) {
        if (!JTattooUtilities.isActive(this)) {
            g.setColor(ColorHelper.brighter(FRAME_COLOR, 20.0));
        } else {
            g.setColor(FRAME_COLOR);
        }
        g.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
    }
}

