/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.hifi;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseToggleButtonUI;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;

public class HiFiToggleButtonUI
extends BaseToggleButtonUI {
    public static ComponentUI createUI(JComponent c) {
        return new HiFiToggleButtonUI();
    }

    @Override
    protected void paintText(Graphics g, AbstractButton b, Rectangle textRect, String text) {
        ButtonModel model = b.getModel();
        FontMetrics fm = JTattooUtilities.getFontMetrics(b, g, b.getFont());
        int mnemIndex = b.getDisplayedMnemonicIndex();
        int offs = 0;
        if (model.isArmed() && model.isPressed()) {
            offs = 1;
        }
        Graphics2D g2D = (Graphics2D)g;
        Composite composite = g2D.getComposite();
        AlphaComposite alpha = AlphaComposite.getInstance(3, 0.6f);
        g2D.setComposite(alpha);
        Color foreground = b.getForeground();
        Color background = b.getBackground();
        if ((model.isPressed() && model.isArmed() || model.isSelected()) && foreground instanceof ColorUIResource && background instanceof ColorUIResource) {
            foreground = AbstractLookAndFeel.getTheme().getPressedForegroundColor();
        }
        if (!model.isEnabled()) {
            foreground = AbstractLookAndFeel.getTheme().getDisabledForegroundColor();
        }
        if (ColorHelper.getGrayValue(foreground) > 128) {
            g2D.setColor(Color.black);
        } else {
            g2D.setColor(Color.white);
        }
        JTattooUtilities.drawStringUnderlineCharAt(b, g, text, mnemIndex, textRect.x + offs + 1, textRect.y + offs + fm.getAscent() + 1);
        g2D.setComposite(composite);
        g2D.setColor(foreground);
        JTattooUtilities.drawStringUnderlineCharAt(b, g, text, mnemIndex, textRect.x + offs, textRect.y + offs + fm.getAscent());
    }
}

