/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.querybuilder;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import nickyb.sqleonardo.common.util.I18n;
import nickyb.sqleonardo.querybuilder.DiagramEntity;
import nickyb.sqleonardo.querybuilder.QueryBuilder;

public abstract class QueryActions {
    public static final String COPY_SYNTAX = "copy-syntax";
    public static final String FIELDS_DRAGGABLE = "fields-draggable";
    public static final String ENTITIES_ARRANGE = "entities-arrange";
    public static final String ENTITIES_PACK = "entities-pack";
    public static final String ENTITIES_REMOVE = "entities-remove";

    static void init(QueryBuilder builder) {
        builder.getActionMap().put(COPY_SYNTAX, new ActionCopySyntax(builder));
        builder.getActionMap().put(FIELDS_DRAGGABLE, new ActionDragAndDrop(builder));
        builder.getActionMap().put(ENTITIES_ARRANGE, new ActionArrangeEntities(builder));
        builder.getActionMap().put(ENTITIES_PACK, new ActionPackEntities(builder));
        builder.getActionMap().put(ENTITIES_REMOVE, new ActionRemoveEntities(builder));
    }

    static class ActionRemoveEntities
    extends AbstractQueryAction {
        ActionRemoveEntities(QueryBuilder builder) {
            super(builder);
            this.putValue("Name", I18n.getString("querybuilder.action.removeEntities", "remove entities"));
        }

        public void actionPerformed(ActionEvent e) {
            if (JOptionPane.showConfirmDialog(this.builder, I18n.getString("querybuilder.message.continue", "do you want to continue?"), I18n.getString("querybuilder.action.removeEntities", "remove entities"), 0, 3) == 1) {
                return;
            }
            DiagramEntity[] entities = this.builder.diagram.getEntities();
            for (int i = 0; i < entities.length; ++i) {
                entities[i].doDefaultCloseAction();
            }
        }
    }

    static class ActionPackEntities
    extends AbstractQueryAction {
        ActionPackEntities(QueryBuilder builder) {
            super(builder);
            this.putValue("Name", I18n.getString("querybuilder.action.packEntities", "pack entities"));
        }

        public void actionPerformed(ActionEvent e) {
            DiagramEntity[] entities = this.builder.diagram.getEntities();
            for (int i = 0; i < entities.length; ++i) {
                entities[i].setPack(true);
            }
        }
    }

    static class ActionArrangeEntities
    extends AbstractQueryAction {
        ActionArrangeEntities(QueryBuilder builder) {
            super(builder);
            this.putValue("Name", I18n.getString("querybuilder.action.arrangeEntities", "arrange entities"));
        }

        public void actionPerformed(ActionEvent e) {
            this.builder.diagram.doArrangeEntities();
        }
    }

    static class ActionCopySyntax
    extends AbstractQueryAction
    implements ClipboardOwner {
        ActionCopySyntax(QueryBuilder builder) {
            super(builder);
            this.putValue("Name", I18n.getString("querybuilder.action.copySyntax", "copy syntax"));
        }

        public void actionPerformed(ActionEvent ae) {
            String value = this.builder.getModel().toString(true);
            Clipboard cb = this.builder.getToolkit().getSystemClipboard();
            StringSelection contents = new StringSelection(value);
            cb.setContents(contents, this);
        }

        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }
    }

    static class ActionDragAndDrop
    extends AbstractQueryAction {
        ActionDragAndDrop(QueryBuilder builder) {
            super(builder);
            this.putValue("Name", I18n.getString("querybuilder.action.join", "join by Drag&Drop"));
        }

        public void actionPerformed(ActionEvent ae) {
            this.builder.setDragAndDropEnabled(!this.builder.isDragAndDropEnabled());
        }
    }

    static abstract class AbstractQueryAction
    extends AbstractAction {
        QueryBuilder builder;

        AbstractQueryAction(QueryBuilder builder) {
            this.builder = builder;
        }
    }
}

