/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.sheet;

import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.PropertiesDialog;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.LanguageChangedEvent;
import it.businesslogic.ireport.util.LanguageChangedListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;

public class PropertiesSheetPropertyComponent
extends JPanel {
    private List propertiesList = null;
    private JButton jButton1;
    private JLabel jLabelList;
    private EventListenerList listenerList = null;

    public List getPropertiesList() {
        return this.propertiesList;
    }

    public void setPropertiesList(List propertiesList) {
        this.propertiesList = propertiesList;
        this.updateLabel();
    }

    public PropertiesSheetPropertyComponent() {
        this.initComponents();
        I18n.addOnLanguageChangedListener(new LanguageChangedListener(){

            public void languageChanged(LanguageChangedEvent evt) {
                PropertiesSheetPropertyComponent.this.applyI18n();
            }
        });
        this.applyI18n();
    }

    public void listChanged() {
        ActionEvent event = new ActionEvent(this, 0, "");
        this.fireActionListenerActionPerformed(event);
    }

    private void initComponents() {
        this.jLabelList = new JLabel();
        this.jButton1 = new JButton();
        this.setBackground(new Color(255, 255, 255));
        this.setLayout(new GridBagLayout());
        this.jLabelList.setBackground(new Color(255, 255, 255));
        this.jLabelList.setOpaque(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.jLabelList, gridBagConstraints);
        this.jButton1.setText("...");
        this.jButton1.setMaximumSize(new Dimension(19, 10));
        this.jButton1.setMinimumSize(new Dimension(19, 10));
        this.jButton1.setPreferredSize(new Dimension(19, 10));
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PropertiesSheetPropertyComponent.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jButton1, gridBagConstraints);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        PropertiesDialog pd = new PropertiesDialog((Frame)MainFrame.getMainInstance(), true);
        pd.setProperties(this.getPropertiesList());
        pd.setVisible(true);
        if (pd.getDialogResult() == 0) {
            this.setPropertiesList(pd.getProperties());
            this.listChanged();
        }
    }

    public synchronized void addActionListener(ActionListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(ActionListener.class, listener);
    }

    public synchronized void removeActionListener(ActionListener listener) {
        this.listenerList.remove(ActionListener.class, listener);
    }

    private void fireActionListenerActionPerformed(ActionEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            ((ActionListener)listeners[i + 1]).actionPerformed(event);
        }
    }

    public void applyI18n() {
        this.updateLabel();
    }

    public void updateLabel() {
        try {
            List list = this.getPropertiesList();
            if (list == null) {
                this.jLabelList.setText("<null>");
            } else {
                this.jLabelList.setText(I18n.getFormattedString("listSheetPropertyComponent.label", "{0} item(s)", new Object[]{new Integer(list.size())}));
            }
            this.jLabelList.updateUI();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

