/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.sheet;

import it.businesslogic.ireport.gui.JNumberComboBox;
import it.businesslogic.ireport.gui.event.SheetPropertyValueChangedEvent;
import it.businesslogic.ireport.gui.sheet.SheetProperty;
import it.businesslogic.ireport.util.Misc;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;

public class NumberComboBoxSheetProperty
extends SheetProperty {
    JNumberComboBox jNumberComboBox = null;

    public NumberComboBoxSheetProperty(String key, String name) {
        super(key, name, 2);
    }

    public Object getEditorValue(JComponent component) {
        return "" + (int)this.jNumberComboBox.getValue();
    }

    public void setValue(Object value) {
        this.value = value;
        this.setEditorValue(this.getEditor(), value == null ? this.getDefaultValue() : value);
        this.updateLabel();
    }

    public void setEditorValue(JComponent component, Object str) {
        if (str == null || str.equals("")) {
            str = this.getDefaultValue();
        }
        if (str == null) {
            str = "";
        }
        boolean setting = this.isSetting();
        this.setSetting(true);
        try {
            ((JComboBox)component).setSelectedItem(str);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setSetting(setting);
    }

    public void addEntry(String name, int value) {
        ((JNumberComboBox)this.getEditor()).addEntry(name, value);
    }

    public JComponent getEditor() {
        if (this.jNumberComboBox != null) {
            return this.jNumberComboBox;
        }
        this.jNumberComboBox = new JNumberComboBox();
        this.jNumberComboBox.setEditable(true);
        this.jNumberComboBox.setBorder(null);
        this.jNumberComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    NumberComboBoxSheetProperty.this.actionPerformed(null);
                }
            }
        });
        this.jNumberComboBox.addActionListener(this);
        return this.jNumberComboBox;
    }

    public void actionPerformed(ActionEvent event) {
        if (this.isSetting()) {
            return;
        }
        Object new_value = this.getEditorValue(this.getEditor());
        if (new_value != null && new_value.equals(this.value)) {
            return;
        }
        if (new_value != null) {
            try {
                Double.parseDouble(new_value + "");
            }
            catch (Exception ex) {
                return;
            }
        }
        Object oldValue = this.value;
        this.value = new_value;
        if (oldValue == null || this.value == null) {
            this.updateLabel();
        }
        this.fireSheetPropertyValueChangedListenerSheetPropertyValueChanged(new SheetPropertyValueChangedEvent(this.getKeyName(), oldValue, this.value, this));
    }

    public void updateValues(Vector values, boolean addNullEntry) {
        Misc.updateComboBox((JComboBox)this.getEditor(), values, addNullEntry);
    }
}

