/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.chart;

import it.businesslogic.ireport.chart.ChartDefinition;
import it.businesslogic.ireport.gui.sheet.SheetProperty;
import it.businesslogic.ireport.gui.sheet.Tag;
import java.util.Vector;
import javax.swing.ImageIcon;

public class AvailableCharts {
    private static Vector charts;
    private static ImageIcon genericChart;

    public static Vector getAvailableCharts() {
        return charts;
    }

    public static ImageIcon getChartIcon(String chartName) {
        for (int i = 0; i < charts.size(); ++i) {
            ChartDefinition cd = (ChartDefinition)charts.elementAt(i);
            if (!cd.getChartName().equals("" + chartName)) continue;
            return cd.getIcon();
        }
        return genericChart;
    }

    public static void addChartSheetProperties(ChartDefinition cd) {
        cd.getSheetProperties().add(new SheetProperty("width", "Width", 6));
        cd.getSheetProperties().add(new SheetProperty("height", "Height", 6));
        cd.getSheetProperties().add(new SheetProperty("quality", "Zoom", 6, "2"));
        cd.getSheetProperties().add(new SheetProperty("title", "Chart title", 0));
        cd.getSheetProperties().add(new SheetProperty("subtitle", "Subtitle", 0));
        SheetProperty nsp = new SheetProperty("titlePosition", "Title position", 5, "1");
        nsp.getTags().add(new Tag(1, "Top"));
        nsp.getTags().add(new Tag(2, "Bottom"));
        nsp.getTags().add(new Tag(3, "Left"));
        nsp.getTags().add(new Tag(4, "Right"));
        cd.getSheetProperties().add(nsp);
        cd.getSheetProperties().add(new SheetProperty("chartBackground", "Chart Background", 3, "[255,255,255]"));
        cd.getSheetProperties().add(new SheetProperty("plotBackground", "Plot Background", 3, "[255,255,255]"));
        cd.getSheetProperties().add(new SheetProperty("antialias", "Antialias", 4, "true"));
        cd.getSheetProperties().add(new SheetProperty("tooltips", "Show tooltips", 4, "false"));
        cd.getSheetProperties().add(new SheetProperty("legend", "Show legend", 4, "false"));
    }

    static {
        genericChart = null;
        charts = new Vector();
        ChartDefinition cd = new ChartDefinition();
        cd.setNeededSeries(new String[]{"Labels", "Serie1"});
        cd.setChartName("Pie");
        cd.setIcon(new ImageIcon(AvailableCharts.class.getClass().getResource("/it/businesslogic/ireport/icons/charts/pie.png")));
        cd.setType("Pie charts");
        cd.setFactory("JFreeChart-0.21");
        AvailableCharts.addChartSheetProperties(cd);
        charts.add(cd);
        ChartDefinition cd2 = new ChartDefinition();
        cd2.setNeededSeries(new String[]{"Labels", "Serie1"});
        cd2.setChartName("Pie3D");
        cd2.setIcon(new ImageIcon(AvailableCharts.class.getClass().getResource("/it/businesslogic/ireport/icons/charts/pie3d.png")));
        cd2.setType("Pie charts");
        cd2.setFactory("JFreeChart-0.21");
        AvailableCharts.addChartSheetProperties(cd2);
        cd2.getSheetProperties().add(new SheetProperty("depthFactor", "Depth factor", 1, "0.2"));
        cd2.getSheetProperties().add(new SheetProperty("foregroundAlpha", "Foreground Alpha", 1, "0.33"));
        charts.add(cd2);
        ChartDefinition cd3 = new ChartDefinition();
        cd3.setNeededSeries(new String[]{"Values", "Categories", "Series"});
        cd3.setChartName("Bar");
        cd3.setIcon(new ImageIcon(AvailableCharts.class.getClass().getResource("/it/businesslogic/ireport/icons/charts/bar.png")));
        cd3.setType("Bar charts");
        cd3.setFactory("JFreeChart-0.21");
        AvailableCharts.addChartSheetProperties(cd3);
        SheetProperty nsp = new SheetProperty("plotOrientation", "Plot orientation", 5, "2");
        nsp.getTags().add(new Tag(1, "Horizontal"));
        nsp.getTags().add(new Tag(2, "Vertical"));
        cd3.getSheetProperties().add(nsp);
        cd3.getSheetProperties().add(new SheetProperty("foregroundAlpha", "Foreground Alpha", 1, "0.33"));
        cd3.getSheetProperties().add(new SheetProperty("valueLabel", "Value label", 0, ""));
        cd3.getSheetProperties().add(new SheetProperty("categoryLabel", "Category label", 0, ""));
        charts.add(cd3);
        ChartDefinition cd4 = new ChartDefinition();
        cd4.setNeededSeries(new String[]{"Values", "Categories", "Series"});
        cd4.setChartName("Bar3D");
        cd4.setIcon(new ImageIcon(AvailableCharts.class.getClass().getResource("/it/businesslogic/ireport/icons/charts/bar3d.png")));
        cd4.setType("Bar charts");
        cd4.setFactory("JFreeChart-0.21");
        AvailableCharts.addChartSheetProperties(cd4);
        nsp = new SheetProperty("plotOrientation", "Plot orientation", 5, "2");
        nsp.getTags().add(new Tag(1, "Horizontal"));
        nsp.getTags().add(new Tag(2, "Vertical"));
        cd4.getSheetProperties().add(nsp);
        cd4.getSheetProperties().add(new SheetProperty("foregroundAlpha", "Foreground Alpha", 1, "0.33"));
        cd4.getSheetProperties().add(new SheetProperty("valueLabel", "Value label", 0, ""));
        cd4.getSheetProperties().add(new SheetProperty("categoryLabel", "Category label", 0, ""));
        charts.add(cd4);
        ChartDefinition cd5 = new ChartDefinition();
        cd5.setNeededSeries(new String[]{"Values", "Categories", "Series"});
        cd5.setChartName("Line");
        cd5.setIcon(new ImageIcon(AvailableCharts.class.getClass().getResource("/it/businesslogic/ireport/icons/charts/line.png")));
        cd5.setType("Bar charts");
        cd5.setFactory("JFreeChart-0.21");
        AvailableCharts.addChartSheetProperties(cd5);
        nsp = new SheetProperty("plotOrientation", "Plot orientation", 5, "2");
        nsp.getTags().add(new Tag(1, "Horizontal"));
        nsp.getTags().add(new Tag(2, "Vertical"));
        cd5.getSheetProperties().add(nsp);
        cd5.getSheetProperties().add(new SheetProperty("foregroundAlpha", "Foreground Alpha", 1, "0.33"));
        cd5.getSheetProperties().add(new SheetProperty("valueLabel", "Y Label label", 0, ""));
        cd5.getSheetProperties().add(new SheetProperty("categoryLabel", "X Label", 0, ""));
        charts.add(cd5);
        ChartDefinition cd6 = new ChartDefinition();
        cd6.setNeededSeries(new String[]{"Values", "Categories", "Series"});
        cd6.setChartName("Area");
        cd6.setIcon(new ImageIcon(AvailableCharts.class.getClass().getResource("/it/businesslogic/ireport/icons/charts/area.png")));
        cd6.setType("Bar charts");
        cd6.setFactory("JFreeChart-0.21");
        AvailableCharts.addChartSheetProperties(cd6);
        nsp = new SheetProperty("plotOrientation", "Plot orientation", 5, "2");
        nsp.getTags().add(new Tag(1, "Horizontal"));
        nsp.getTags().add(new Tag(2, "Vertical"));
        cd6.getSheetProperties().add(nsp);
        cd6.getSheetProperties().add(new SheetProperty("foregroundAlpha", "Foreground Alpha", 1, "0.33"));
        cd6.getSheetProperties().add(new SheetProperty("valueLabel", "Y Label label", 0, ""));
        cd6.getSheetProperties().add(new SheetProperty("categoryLabel", "X Label", 0, ""));
        charts.add(cd6);
        genericChart = new ImageIcon(AvailableCharts.class.getClass().getResource("/it/businesslogic/ireport/icons/charts/genericChart.png"));
    }
}

