/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport;

import it.businesslogic.ireport.Band;
import it.businesslogic.ireport.Box;
import it.businesslogic.ireport.GraphicReportElement;
import it.businesslogic.ireport.IReportHashMapBean;
import it.businesslogic.ireport.JRProperty;
import it.businesslogic.ireport.Pen;
import it.businesslogic.ireport.Style;
import it.businesslogic.ireport.TransformationType;
import it.businesslogic.ireport.crosstab.CrosstabCell;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.util.CompoundStroke;
import it.businesslogic.ireport.util.Misc;
import it.businesslogic.ireport.util.ShapeStroke;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;

public class ReportElement
extends IReportHashMapBean {
    private static ImageIcon gripIcon = new ImageIcon(ReportElement.class.getResource("/it/businesslogic/ireport/icons/grip.png"));
    static int id_gen = 1;
    private int elementID = 0;
    public static final String BGCOLOR = "BGCOLOR";
    public static final String FGCOLOR = "FGCOLOR";
    public static final String MODE = "MODE";
    public static final String REMOVE_LINE_WHEN_BLANK = "REMOVE_LINE_WHEN_BLANK";
    public static final String PRINT_REPEATED_VALUES = "PRINT_REPEATED_VALUES";
    public static final String PRINT_IN_FIRST_WHOLE_BAND = "DEFAULT_PRINT_IN_FIRST_WHOLE_BAND";
    public static final String PRINT_WHEN_DETAIL_OVERFLOW = "PRINT_WHEN_DETAIL_OVERFLOW";
    public static final String POSITION_TYPE = "POSITION_TYPE";
    public static final Color DEFAULT_BGCOLOR = Color.WHITE;
    public static final Color DEFAULT_FGCOLOR = Color.BLACK;
    public static final boolean DEFAULT_REMOVE_LINE_WHEN_BLANK = false;
    public static final boolean DEFAULT_PRINT_REPEATED_VALUES = true;
    public static final boolean DEFAULT_PRINT_IN_FIRST_WHOLE_BAND = false;
    public static final boolean DEFAULT_PRINT_WHEN_DETAIL_OVERFLOW = false;
    public static final String DEFAULT_POSITION_TYPE = "FixRelativeToTop";
    public String transparentDefault = "Opaque";
    public List elementProperties = new ArrayList();
    public String name;
    public Point position;
    private Point relativePosition;
    public int width;
    public int height;
    Rectangle bounds;
    public static BufferedImage hached = null;
    public Band band;
    private CrosstabCell cell;
    public String printWhenExpression = "";
    public static Color lightcolor;
    public String printWhenGroupChanges = "";
    double zoom_factor = 1.0;
    protected String stretchType;
    private String elementGroup = "";
    public Vector intersections = new Vector();
    private Style style = null;
    private ReportElement parentElement = null;

    public List getElementProperties() {
        return this.elementProperties;
    }

    public void setElementProperties(List elementProperties) {
        this.elementProperties = elementProperties;
    }

    public ReportElement(int x, int y, int width, int height) {
        if (hached == null) {
            hached = Misc.loadBufferedImageFromResources(new Panel(), "it/businesslogic/ireport/icons/layout/hached.gif");
        }
        this.position = new Point(x, y);
        this.setRelativePosition(new Point(x, y));
        this.width = Math.abs(width);
        this.height = Math.abs(height);
        this.bounds = new Rectangle(this.position.x, this.position.y, width, height);
        this.name = "element-" + id_gen;
        this.setElementID(id_gen);
        ++id_gen;
        if (lightcolor == null) {
            String lc = MainFrame.getMainInstance().getProperties().getProperty("NewViewBorderColor");
            try {
                lightcolor = new Color(Integer.parseInt(lc));
            }
            catch (Exception ex) {
                lightcolor = Color.LIGHT_GRAY;
            }
        }
        this.stretchType = "NoStretch";
    }

    public void drawObject(Graphics2D g, double zoom_factor, int x_shift_origin, int y_shift_origin) {
        this.position.x -= 10;
        this.position.y -= 10;
        this.zoom_factor = zoom_factor;
        g.fillRect(this.getZoomedDim(this.position.x) - (x_shift_origin -= 10), this.getZoomedDim(this.position.y) - (y_shift_origin -= 10), this.getZoomedDim(this.width), this.getZoomedDim(this.height));
        this.position.x += 10;
        this.position.y += 10;
        this.drawGraphicsElement(g, "2Point", zoom_factor, x_shift_origin += 10, y_shift_origin += 10);
        this.drawBorder(g, zoom_factor, x_shift_origin, y_shift_origin);
    }

    public void drawGraphicsElement(Graphics2D g, String pen, double zoom_factor, int x_shift_origin, int y_shift_origin) {
        this.drawGraphicsElement(g, pen, zoom_factor, x_shift_origin, y_shift_origin, 0);
    }

    public void drawGraphicsElement(Graphics2D g, String pen, double zoom_factor, int x_shift_origin, int y_shift_origin, int radius) {
        int correction = zoom_factor <= 1.0 && (pen.equals("Thin") || pen.equals("1Point") || pen.equals("Dotted")) ? -1 : 0;
        int xy_correction = zoom_factor <= 1.0 && pen.equals("Dotted") ? 1 : 0;
        Pen thePen = null;
        if (this instanceof GraphicReportElement) {
            thePen = ((GraphicReportElement)this).getPen();
        }
        Stroke stroke = ReportElement.getPenStroke(pen, thePen, zoom_factor);
        g.setColor(this.getFgcolor());
        this.zoom_factor = zoom_factor;
        if (stroke == null || pen == null && pen.equalsIgnoreCase("None")) {
            return;
        }
        this.position.x -= 10;
        this.position.y -= 10;
        x_shift_origin -= 10;
        y_shift_origin -= 10;
        Stroke oldStroke = g.getStroke();
        g.setStroke(stroke);
        if (radius != 0) {
            g.drawRoundRect(this.getZoomedDim(this.position.x) - x_shift_origin + xy_correction, this.getZoomedDim(this.position.y) - y_shift_origin + xy_correction, this.getZoomedDim(this.width) + correction, this.getZoomedDim(this.height) + correction, this.getZoomedDim(radius), this.getZoomedDim(radius));
        } else {
            g.drawRect(this.getZoomedDim(this.position.x) - x_shift_origin + xy_correction, this.getZoomedDim(this.position.y) - y_shift_origin + xy_correction, this.getZoomedDim(this.width) + correction, this.getZoomedDim(this.height) + correction);
        }
        this.position.x += 10;
        this.position.y += 10;
        g.setStroke(oldStroke);
    }

    public void drawBorder(Graphics2D g, double zoom_factor, int x_shift_origin, int y_shift_origin) {
        this.drawBorder(g, zoom_factor, x_shift_origin, y_shift_origin, null);
    }

    public void drawBorder(Graphics2D g, double zoom_factor, int x_shift_origin, int y_shift_origin, Box box) {
        this.zoom_factor = zoom_factor;
        int correction = -1;
        this.position.x -= 10;
        this.position.y -= 10;
        x_shift_origin -= 10;
        y_shift_origin -= 10;
        Stroke oldStroke = g.getStroke();
        boolean b_insideBand = this.insideBand();
        if (box == null || !b_insideBand) {
            if (b_insideBand) {
                g.setColor(lightcolor);
            } else {
                g.setColor(Color.RED);
            }
            g.drawRect(this.getZoomedDim(this.position.x) - x_shift_origin, this.getZoomedDim(this.position.y) - y_shift_origin, this.getZoomedDim(this.width) + correction, this.getZoomedDim(this.height) + correction);
        } else {
            boolean insideBand = this.insideBand();
            int ax = this.getZoomedDim(this.position.x) - x_shift_origin;
            int ay = this.getZoomedDim(this.position.y) - y_shift_origin;
            int bx = ax + this.getZoomedDim(this.width) + correction;
            int by = ay + this.getZoomedDim(this.height) + correction;
            Stroke newBoxStroke = null;
            Object pen = null;
            if (box.getLeftPen() != null && box.getLeftPen().getLineColor() != null) {
                g.setColor(box.getLeftPen().getLineColor());
            } else if (box.getLeftBorderColor() != null) {
                g.setColor(box.getLeftBorderColor());
            } else {
                g.setColor(lightcolor);
            }
            newBoxStroke = ReportElement.getPenStroke(box.getLeftBorder(), box.getLeftPen(), zoom_factor);
            if (newBoxStroke != null) {
                g.setStroke(newBoxStroke);
                g.drawLine(ax, ay, ax, by);
            }
            if (box.getTopPen() != null && box.getTopPen().getLineColor() != null) {
                g.setColor(box.getTopPen().getLineColor());
            } else if (box.getTopBorderColor() != null) {
                g.setColor(box.getTopBorderColor());
            } else {
                g.setColor(lightcolor);
            }
            newBoxStroke = ReportElement.getPenStroke(box.getTopBorder(), box.getTopPen(), zoom_factor);
            if (newBoxStroke != null) {
                g.setStroke(newBoxStroke);
                g.drawLine(ax, ay, bx, ay);
            }
            if (box.getRightPen() != null && box.getRightPen().getLineColor() != null) {
                g.setColor(box.getRightPen().getLineColor());
            } else if (box.getRightBorderColor() != null) {
                g.setColor(box.getRightBorderColor());
            } else {
                g.setColor(lightcolor);
            }
            newBoxStroke = ReportElement.getPenStroke(box.getRightBorder(), box.getRightPen(), zoom_factor);
            if (newBoxStroke != null) {
                g.setStroke(newBoxStroke);
                g.drawLine(bx, ay, bx, by);
            }
            if (box.getBottomPen() != null && box.getBottomPen().getLineColor() != null) {
                g.setColor(box.getBottomPen().getLineColor());
            } else if (box.getBottomBorderColor() != null) {
                g.setColor(box.getBottomBorderColor());
            } else {
                g.setColor(lightcolor);
            }
            newBoxStroke = ReportElement.getPenStroke(box.getBottomBorder(), box.getBottomPen(), zoom_factor);
            if (newBoxStroke != null) {
                g.setStroke(newBoxStroke);
                g.drawLine(ax, by, bx, by);
            }
            g.setStroke(oldStroke);
        }
        this.position.x += 10;
        this.position.y += 10;
        x_shift_origin += 10;
        y_shift_origin += 10;
    }

    public static Color getAlphaColor(Color c, int alpha) {
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
    }

    public void writeGrip(Graphics2D g, int x, int y) {
        g.drawImage(gripIcon.getImage(), x - 3, y - 3, gripIcon.getImageObserver());
        g.fillRect(x, y, 5, 5);
    }

    public void drawCorona(Graphics2D g, double zoom_factor, int x_shift_origin, int y_shift_origin, boolean selected) {
        this.zoom_factor = zoom_factor;
        this.position.x -= 10;
        this.position.y -= 10;
        Rectangle rInteger = new Rectangle(this.getZoomedDim(this.position.x) - 3 - (x_shift_origin -= 10), this.getZoomedDim(this.position.y) - 3 - (y_shift_origin -= 10), this.getZoomedDim(this.width) + 6, this.getZoomedDim(this.height) + 6);
        Rectangle2D.Double r = new Rectangle2D.Double(rInteger.getX(), rInteger.getY(), rInteger.getWidth(), rInteger.getHeight());
        Rectangle2D.Double r2 = new Rectangle2D.Double(rInteger.getX() + 2.0, rInteger.getY() + 2.0, rInteger.getWidth() - 4.0, rInteger.getHeight() - 4.0);
        Area area = new Area(r);
        area.exclusiveOr(new Area(r2));
        g.setPaint(new Color(255, 175, 0, 200));
        g.fill(area);
        g.setPaint(ReportElement.getAlphaColor(Color.BLUE, 80));
        if (!selected) {
            g.setPaint(ReportElement.getAlphaColor(Color.GRAY, 80));
        }
        if (this.intersectsElements()) {
            if (this.enclosesOtherElement()) {
                g.setPaint(ReportElement.getAlphaColor(Color.PINK, 80));
            } else {
                g.setPaint(ReportElement.getAlphaColor(Color.GREEN, 80));
            }
        }
        if (!this.insideBand()) {
            g.setPaint(ReportElement.getAlphaColor(Color.RED, 80));
        }
        this.writeGrip(g, this.getZoomedDim(this.position.x) - 5 - x_shift_origin, this.getZoomedDim(this.position.y) - 5 - y_shift_origin);
        this.writeGrip(g, this.getZoomedDim(this.position.x) - 5 - x_shift_origin, this.getZoomedDim(this.position.y) - 5 - y_shift_origin);
        this.writeGrip(g, this.getZoomedDim(this.position.x + this.width) - x_shift_origin, this.getZoomedDim(this.position.y) - 5 - y_shift_origin);
        this.writeGrip(g, this.getZoomedDim(this.position.x + this.width) - x_shift_origin, this.getZoomedDim(this.position.y + this.height) - y_shift_origin);
        this.writeGrip(g, this.getZoomedDim(this.position.x) - 5 - x_shift_origin, this.getZoomedDim(this.position.y + this.height) - y_shift_origin);
        this.writeGrip(g, this.getZoomedDim(this.position.x + this.width / 2) - 2 - x_shift_origin, this.getZoomedDim(this.position.y) - 5 - y_shift_origin);
        this.writeGrip(g, this.getZoomedDim(this.position.x + this.width / 2) - 2 - x_shift_origin, this.getZoomedDim(this.position.y + this.height) - y_shift_origin);
        this.writeGrip(g, this.getZoomedDim(this.position.x) - 5 - x_shift_origin, this.getZoomedDim(this.position.y + this.height / 2) - 2 - y_shift_origin);
        this.writeGrip(g, this.getZoomedDim(this.position.x + this.width) - x_shift_origin, this.getZoomedDim(this.position.y + this.height / 2) - 2 - y_shift_origin);
        this.position.x += 10;
        this.position.y += 10;
    }

    public boolean enclosesOtherElement() {
        for (ReportElement e : this.intersections) {
            if (!this.bounds.contains(e.bounds)) continue;
            return true;
        }
        return false;
    }

    public boolean intersectsElements() {
        int oldHeight = 0;
        boolean result = false;
        Iterator i = null;
        if (this.band == null && this.cell == null) {
            return false;
        }
        i = this.band != null ? this.band.getParent().getElements().iterator() : this.cell.getParent().getElements().iterator();
        while (i.hasNext()) {
            ReportElement e = (ReportElement)i.next();
            if (this.equals(e)) continue;
            oldHeight = e.height;
            if (e.height == 0) {
                e.height = 10;
            }
            if (e.bounds.intersects(this.bounds)) {
                this.intersections.add(e);
                result = true;
            }
            e.height = oldHeight;
        }
        return result;
    }

    public boolean intersects(Point p) {
        Rectangle r = new Rectangle(this.bounds);
        if (this.height == 0) {
            r.height = 10;
            r.y -= 5;
        }
        if (this.width == 0) {
            r.width = 10;
            r.x -= 5;
        }
        return r.intersects(p.x, p.y, 1.0, 1.0);
    }

    public boolean insideBandReal() {
        this.position.x -= 10;
        this.position.y -= 10;
        boolean result = this.insideBand();
        this.position.x += 10;
        this.position.y += 10;
        return result;
    }

    public boolean insideBand() {
        if (this.band == null) {
            if (this.cell != null) {
                return this.cell.getBounds().contains(new Rectangle(this.getPosition().x, this.getPosition().y, this.width, this.height));
            }
            return false;
        }
        int yband = this.band.getBandYLocation();
        if (this.position.y - yband < 0) {
            // empty if block
        }
        if (this.position.x - this.band.getParent().getLeftMargin() < 0) {
            // empty if block
        }
        if (this.position.y - yband + this.height > this.band.getHeight()) {
            return false;
        }
        return this.position.x - this.band.getParent().getLeftMargin() + this.width <= this.band.getUsableWidth();
    }

    public boolean intersects(Rectangle r2) {
        Rectangle r = new Rectangle(this.bounds);
        if (this.height == 0) {
            r.height = 10;
            r.y -= 5;
        }
        if (this.width == 0) {
            r.width = 10;
            r.x -= 5;
        }
        return r.intersects(r2);
    }

    public void setPosition(Point p) {
        if (p == null) {
            return;
        }
        if (p.x == this.position.x && p.y == this.position.y) {
            return;
        }
        this.position.x = p.x;
        this.position.y = p.y;
        this.bounds = new Rectangle(this.position.x, this.position.y, this.width, this.height);
    }

    public Point trasform(Point delta, int type) {
        if (delta == null) {
            return null;
        }
        Point result = new Point(delta);
        int old_x = 0;
        int old_y = 0;
        if (type == TransformationType.TRANSFORMATION_MOVE) {
            this.position.x += delta.x;
            this.position.y += delta.y;
        } else if (type == TransformationType.TRANSFORMATION_RESIZE_E) {
            old_x = this.width;
            this.width += delta.x;
            if (this.width < 0) {
                this.width = 0;
            }
            result.x = this.width - old_x;
        } else if (type == TransformationType.TRANSFORMATION_RESIZE_W) {
            old_x = this.width;
            int d = Math.min(delta.x, this.width);
            this.width -= d;
            this.position.x += d;
            result.x = d;
        } else if (type == TransformationType.TRANSFORMATION_RESIZE_N) {
            int d = Math.min(delta.y, this.height);
            this.height -= d;
            this.position.y += d;
            result.y = d;
        } else if (type == TransformationType.TRANSFORMATION_RESIZE_S) {
            old_y = this.height;
            this.height += delta.y;
            if (this.height < 0) {
                this.height = 0;
            }
            result.y = this.height - old_y;
        } else if (type == TransformationType.TRANSFORMATION_RESIZE_SE) {
            old_y = this.height;
            old_x = this.width;
            this.height += delta.y;
            if (this.height < 0) {
                this.height = 0;
            }
            this.width += delta.x;
            if (this.width < 0) {
                this.width = 0;
            }
            result.x = this.width - old_x;
            result.y = this.height - old_y;
        } else if (type == TransformationType.TRANSFORMATION_RESIZE_SW) {
            old_y = this.height;
            this.height += delta.y;
            if (this.height < 0) {
                this.height = 0;
            }
            int d = Math.min(delta.x, this.width);
            this.width -= d;
            this.position.x += d;
            result.x = d;
            result.y = this.height - old_y;
        } else if (type == TransformationType.TRANSFORMATION_RESIZE_NE) {
            old_x = this.width;
            int d = Math.min(delta.y, this.height);
            this.height -= d;
            this.position.y += d;
            this.width += delta.x;
            if (this.width < 0) {
                this.width = 0;
            }
            result.x = this.width - old_x;
            result.y = d;
        } else if (type == TransformationType.TRANSFORMATION_RESIZE_NW) {
            int d = Math.min(delta.y, this.height);
            this.height -= d;
            this.position.y += d;
            result.y = d;
            d = Math.min(delta.x, this.width);
            this.width -= d;
            this.position.x += d;
            result.x = d;
        }
        this.bounds = new Rectangle(this.position.x, this.position.y, this.width, this.height);
        if (this.getCell() != null && type != TransformationType.TRANSFORMATION_RESIZE_SE) {
            this.setRelativePosition(new Point(this.getPosition().x - this.getCell().getLeft() - 10, this.getPosition().y - this.getCell().getTop() - 10));
        }
        return result;
    }

    public void adjustBand() {
        if (this.band == null) {
            return;
        }
        this.position.x -= 10;
        this.position.y -= 10;
        for (Band b : this.band.getParent().getBands()) {
            if (this.position.y - this.band.getParent().getBandYLocation(b) < 0 || this.position.y - this.band.getParent().getBandYLocation(b) + this.height > b.getHeight()) continue;
            this.band = b;
            break;
        }
        this.position.x += 10;
        this.position.y += 10;
    }

    public void adjustCell(Vector cells) {
        if (this.getCell().getType() == 2) {
            return;
        }
        for (int i = 0; i < cells.size(); ++i) {
            CrosstabCell tmpCell = (CrosstabCell)cells.elementAt(i);
            if (tmpCell.getType() == 2 || !tmpCell.getBounds().contains(new Point(this.getPosition().x - 10, this.getPosition().y - 10))) continue;
            this.setCell(tmpCell);
            this.setRelativePosition(new Point(this.getPosition().x - this.getCell().getLeft() - 10, this.getPosition().y - this.getCell().getTop() - 10));
            return;
        }
    }

    public void updateRelativePosition() {
        if (this.getCell() == null) {
            return;
        }
        this.setRelativePosition(new Point(this.getPosition().x - this.getCell().getLeft() - 10, this.getPosition().y - this.getCell().getTop() - 10));
    }

    public void updateBounds() {
        this.bounds = new Rectangle(this.position.x, this.position.y, this.width, this.height);
    }

    public Point trasformTest(Point delta, int type) {
        if (delta == null) {
            return null;
        }
        Point result = new Point(delta);
        int old_x = 0;
        int old_y = 0;
        if (type != TransformationType.TRANSFORMATION_MOVE) {
            if (type == TransformationType.TRANSFORMATION_RESIZE_E) {
                old_x = this.width;
                if ((old_x += delta.x) < 0) {
                    old_x = 0;
                }
                result.x = old_x - this.width;
            } else if (type == TransformationType.TRANSFORMATION_RESIZE_W) {
                result.x = Math.min(delta.x, this.width);
            } else if (type == TransformationType.TRANSFORMATION_RESIZE_N) {
                result.y = Math.min(delta.y, this.height);
            } else if (type == TransformationType.TRANSFORMATION_RESIZE_S) {
                old_y = this.height;
                if ((old_y += delta.y) < 0) {
                    old_y = 0;
                }
                result.y = old_y - this.height;
            } else if (type == TransformationType.TRANSFORMATION_RESIZE_SE) {
                old_y = this.height;
                old_x = this.width;
                if ((old_y += delta.y) < 0) {
                    old_y = 0;
                }
                if ((old_x += delta.x) < 0) {
                    old_x = 0;
                }
                result.x = old_x - this.width;
                result.y = old_y - this.height;
            } else if (type == TransformationType.TRANSFORMATION_RESIZE_SW) {
                old_y = this.height;
                if ((old_y += delta.y) < 0) {
                    old_y = 0;
                }
                result.x = Math.min(delta.x, this.width);
                result.y = old_y - this.height;
            } else if (type == TransformationType.TRANSFORMATION_RESIZE_NE) {
                old_x = this.width;
                result.y = Math.min(delta.y, this.height);
                if ((old_x += delta.x) < 0) {
                    old_x = 0;
                }
                result.x = old_x - this.width;
            } else if (type == TransformationType.TRANSFORMATION_RESIZE_NW) {
                result.y = Math.min(delta.y, this.height);
                result.x = Math.min(delta.x, this.width);
            }
        }
        return result;
    }

    public String toString() {
        if (this.band == null) {
            return "" + this.name;
        }
        if (this.getParentElement() == null) {
            return this.name + " [" + (this.position.x - this.band.getParent().getRightMargin() - 10) + "," + (this.position.y - this.band.getBandYLocation() - 10) + "]";
        }
        return this.name + " [" + (this.position.x - this.getParentElement().getPosition().x) + "," + (this.position.y - this.getParentElement().getPosition().y) + "]";
    }

    public int getZoomedDim(int dim) {
        if (this.zoom_factor == 1.0) {
            return dim;
        }
        return (int)((double)dim * this.zoom_factor);
    }

    public double getZoomedDim(double dim) {
        if (this.zoom_factor == 1.0) {
            return dim;
        }
        return dim * this.zoom_factor;
    }

    public int getLogicalDim(int dim) {
        if (this.zoom_factor == 1.0) {
            return dim;
        }
        return (int)((double)dim / this.zoom_factor);
    }

    public ReportElement cloneMe() {
        ReportElement newReportElement = new ReportElement(this.position.x, this.position.y, this.width, this.height);
        newReportElement.name = new String(this.name);
        newReportElement.band = this.band;
        newReportElement.cell = this.cell;
        newReportElement.parentElement = this.parentElement;
        this.copyElementPropertiesTo(newReportElement);
        return newReportElement;
    }

    public void copyElementPropertiesTo(ReportElement newReportElement) {
        newReportElement.printWhenExpression = this.printWhenExpression;
        newReportElement.setPropertyValue(POSITION_TYPE, this.getPropertyValue(POSITION_TYPE));
        newReportElement.setPropertyValue(REMOVE_LINE_WHEN_BLANK, this.getPropertyValue(REMOVE_LINE_WHEN_BLANK));
        newReportElement.setPropertyValue(PRINT_REPEATED_VALUES, this.getPropertyValue(PRINT_REPEATED_VALUES));
        newReportElement.setPropertyValue(PRINT_IN_FIRST_WHOLE_BAND, this.getPropertyValue(PRINT_IN_FIRST_WHOLE_BAND));
        newReportElement.setPropertyValue(PRINT_WHEN_DETAIL_OVERFLOW, this.getPropertyValue(PRINT_WHEN_DETAIL_OVERFLOW));
    }

    public void copyCustomElementPropertiesTo(ReportElement source, ReportElement newReportElement) {
        List props = source.getElementProperties();
        for (int i = 0; i < props.size(); ++i) {
            JRProperty property = (JRProperty)props.get(i);
            newReportElement.getElementProperties().add(property.cloneMe());
        }
    }

    public static String string_replace(String s1, String s2, String s3) {
        String string = "";
        string = "";
        if (s2 == null || s3 == null || s2.length() == 0) {
            return s3;
        }
        int pos_i = 0;
        int pos_f = 0;
        int len = s2.length();
        while ((pos_f = s3.indexOf(s2, pos_i)) >= 0) {
            string = string + s3.substring(pos_i, pos_f) + s1;
            pos_f = pos_i = pos_f + len;
        }
        string = string + s3.substring(pos_i);
        return string;
    }

    public Stroke getPenStroke(String penName, double zoom_factor) {
        Pen thePen = null;
        if (this instanceof GraphicReportElement) {
            thePen = ((GraphicReportElement)this).getPen();
        }
        return ReportElement.getPenStroke(penName, thePen, zoom_factor);
    }

    public static Stroke getPenStroke(String penName, Pen pen, double zoom_factor) {
        if (pen != null) {
            if (pen.getLineWidth() == 0.0f) {
                return null;
            }
            if (pen.getLineStyle() != null) {
                float penWidth = (float)((double)pen.getLineWidth() * zoom_factor);
                if (pen.getLineStyle().equals("Solid")) {
                    return new BasicStroke((float)((double)penWidth * zoom_factor));
                }
                if (pen.getLineStyle().equals("Dashed")) {
                    return new BasicStroke(penWidth, 0, 2, 0.0f, new float[]{Math.max(1.0f, 5.0f * penWidth), Math.max(1.0f, 3.0f * penWidth)}, 0.0f);
                }
                if (pen.getLineStyle().equals("Dotted")) {
                    return new BasicStroke(penWidth, 0, 2, 0.0f, new float[]{Math.max(1.0f, 1.0f * penWidth), Math.max(1.0f, 1.0f * penWidth)}, 0.0f);
                }
                if (pen.getLineStyle().equals("Double")) {
                    float side = (float)((double)penWidth * zoom_factor);
                    ShapeStroke s1 = new ShapeStroke(new Rectangle2D.Float(0.0f, 0.0f, side, side), 1.0f * penWidth);
                    ShapeStroke s2 = new ShapeStroke(new Rectangle2D.Float(0.0f, side / 2.0f, side, side / 3.0f), 1.0f * penWidth);
                    return new CompoundStroke(s1, s2, 1);
                }
            }
        }
        if (penName == null || penName.equals("None")) {
            return null;
        }
        if (penName.equals("Dotted")) {
            return new BasicStroke((float)(1.0 * zoom_factor), 0, 2, 0.0f, new float[]{5.0f, 3.0f}, 0.0f);
        }
        if (penName.equals("2Point")) {
            return new BasicStroke((float)(2.0 * zoom_factor));
        }
        if (penName.equals("3Point")) {
            return new BasicStroke((float)(3.0 * zoom_factor));
        }
        if (penName.equals("4Point")) {
            return new BasicStroke((float)(4.0 * zoom_factor));
        }
        if (penName.equals("Thin")) {
            return new BasicStroke((float)(1.0 * zoom_factor));
        }
        return new BasicStroke((float)(1.0 * zoom_factor));
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
        this.updateBounds();
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
        this.updateBounds();
    }

    public Point getPosition() {
        return this.position;
    }

    public Band getBand() {
        return this.band;
    }

    public void setBand(Band band) {
        this.band = band;
    }

    public String getTransparent() {
        if (this.getStringValue(MODE, null) == null && this.getStyle() != null) {
            Style style = this.getStyle();
            this.getStyle();
            return style.getAttributeString("mode", this.transparentDefault, true);
        }
        return this.getStringValue(MODE, this.transparentDefault);
    }

    public void setTransparent(String transparent) {
        this.setPropertyValue(MODE, transparent);
    }

    public String getPositionType() {
        return this.getStringValue(POSITION_TYPE, DEFAULT_POSITION_TYPE);
    }

    public void setPositionType(String positionType) {
        this.setPropertyValue(POSITION_TYPE, positionType);
    }

    public boolean isIsPrintInFirstWholeBand() {
        return this.getBooleanValue(PRINT_IN_FIRST_WHOLE_BAND, false);
    }

    public void setIsPrintInFirstWholeBand(boolean isPrintInFirstWholeBand) {
        this.setPropertyValue(PRINT_IN_FIRST_WHOLE_BAND, "" + isPrintInFirstWholeBand);
    }

    public String getPrintWhenExpression() {
        return this.printWhenExpression;
    }

    public void setPrintWhenExpression(String printWhenExpression) {
        this.printWhenExpression = printWhenExpression;
    }

    public boolean isIsPrintRepeatedValues() {
        return this.getBooleanValue(PRINT_REPEATED_VALUES, true);
    }

    public void setIsPrintRepeatedValues(boolean isPrintRepeatedValues) {
        this.setPropertyValue(PRINT_REPEATED_VALUES, "" + isPrintRepeatedValues);
    }

    public Color getFgcolor() {
        if (this.getColorValue(FGCOLOR, null) == null && this.getStyle() != null) {
            Style style = this.getStyle();
            this.getStyle();
            return style.getAttributeColor("forecolor", DEFAULT_FGCOLOR, true);
        }
        return this.getColorValue(FGCOLOR, DEFAULT_FGCOLOR);
    }

    public void setFgcolor(Color fgcolor) {
        this.setPropertyValue(FGCOLOR, fgcolor);
    }

    public Color getBgcolor() {
        if (this.getColorValue(BGCOLOR, null) == null && this.getStyle() != null) {
            Style style = this.getStyle();
            this.getStyle();
            return style.getAttributeColor("backcolor", DEFAULT_BGCOLOR, true);
        }
        return this.getColorValue(BGCOLOR, DEFAULT_BGCOLOR);
    }

    public void setBgcolor(Color bgcolor) {
        this.setPropertyValue(BGCOLOR, bgcolor);
    }

    public boolean isIsRemoveLineWhenBlank() {
        return this.getBooleanValue(REMOVE_LINE_WHEN_BLANK, false);
    }

    public void setIsRemoveLineWhenBlank(boolean isRemoveLineWhenBlank) {
        this.setPropertyValue(REMOVE_LINE_WHEN_BLANK, "" + isRemoveLineWhenBlank);
    }

    public String getPrintWhenGroupChanges() {
        return this.printWhenGroupChanges;
    }

    public void setPrintWhenGroupChanges(String printWhenGroupChanges) {
        this.printWhenGroupChanges = printWhenGroupChanges;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isIsPrintWhenDetailOverflows() {
        return this.getBooleanValue(PRINT_WHEN_DETAIL_OVERFLOW, false);
    }

    public void setIsPrintWhenDetailOverflows(boolean isPrintWhenDetailOverflows) {
        this.setPropertyValue(PRINT_WHEN_DETAIL_OVERFLOW, "" + isPrintWhenDetailOverflows);
    }

    public void copyBaseReportElement(ReportElement destination, ReportElement source) {
        destination.setName(new String(source.getName()));
        destination.setPropertyValue(FGCOLOR, this.getPropertyValue(FGCOLOR));
        destination.setPropertyValue(BGCOLOR, this.getPropertyValue(BGCOLOR));
        destination.setBand(source.getBand());
        destination.setCell(source.getCell());
        destination.setPositionType(new String(source.getPositionType()));
        destination.setPropertyValue(REMOVE_LINE_WHEN_BLANK, this.getPropertyValue(REMOVE_LINE_WHEN_BLANK));
        destination.setPropertyValue(PRINT_REPEATED_VALUES, this.getPropertyValue(PRINT_REPEATED_VALUES));
        destination.setPropertyValue(PRINT_IN_FIRST_WHOLE_BAND, this.getPropertyValue(PRINT_IN_FIRST_WHOLE_BAND));
        destination.setPropertyValue(PRINT_WHEN_DETAIL_OVERFLOW, this.getPropertyValue(PRINT_WHEN_DETAIL_OVERFLOW));
        destination.setPropertyValue(MODE, this.getPropertyValue(MODE));
        destination.setStretchType(source.getStretchType());
        destination.setStyle(this.getStyle());
        destination.setPrintWhenExpression(new String(source.getPrintWhenExpression()));
        destination.setPrintWhenGroupChanges(new String(source.getPrintWhenGroupChanges()));
        this.copyCustomElementPropertiesTo(source, destination);
    }

    public String getKey() {
        return this.name;
    }

    public void setKey(String key) {
        this.name = key;
    }

    public String getStretchType() {
        return this.stretchType;
    }

    public void setStretchType(String stretchType) {
        this.stretchType = stretchType;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void setBounds(Rectangle bounds) {
        this.position.x = bounds.x;
        this.position.y = bounds.y;
        this.width = bounds.width;
        this.height = bounds.height;
        this.updateBounds();
    }

    public void addToGroup(String groupname) {
        if (this.getElementGroup() == null || this.getElementGroup().equals("")) {
            this.setElementGroup(this.getElementGroup() + groupname);
        } else {
            this.setElementGroup(groupname + "." + this.getElementGroup());
        }
    }

    public void removeFromGroup(String groupname) {
        if (this.getElementGroup() == null || this.getElementGroup().equals("")) {
            return;
        }
        if (this.getElementGroup().startsWith(groupname)) {
            this.setElementGroup(this.getElementGroup().substring(groupname.length()));
            if (this.getElementGroup().startsWith(".")) {
                this.setElementGroup(this.getElementGroup().substring(1));
            }
        }
    }

    public void removeFromAllGroups() {
        this.setElementGroup("");
    }

    public String getElementGroup() {
        return this.elementGroup;
    }

    public void setElementGroup(String elementGroup) {
        this.elementGroup = elementGroup;
    }

    public ReportElement getParentElement() {
        return this.parentElement;
    }

    public void setParentElement(ReportElement parentElement) {
        this.parentElement = parentElement;
    }

    public int getElementID() {
        return this.elementID;
    }

    public void setElementID(int elementID) {
        this.elementID = elementID;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
        if (style != null) {
            // empty if block
        }
    }

    public CrosstabCell getCell() {
        return this.cell;
    }

    public void setCell(CrosstabCell cell) {
        this.cell = cell;
    }

    public Point getRelativePosition() {
        return this.relativePosition;
    }

    public void setRelativePosition(Point relativePosition) {
        this.relativePosition = relativePosition;
    }
}

