/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.annotations;

import java.util.HashMap;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.AppearanceState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Appearance {
    private HashMap<Name, AppearanceState> appearance;
    private Name selectedName = Annotation.APPEARANCE_STREAM_NORMAL_KEY;
    private Name offName = new Name("Off");
    private Name onName = new Name("Yes");

    public Appearance() {
        this.appearance = new HashMap(2);
    }

    public boolean hasAlternativeAppearance() {
        return this.offName != null || this.onName != null;
    }

    public void addAppearance(Name name, AppearanceState appearanceState) {
        this.appearance.put(name, appearanceState);
        if (name.getName().toLowerCase().equals("off")) {
            this.offName = name;
        } else {
            this.onName = name;
        }
    }

    public Name getOffName() {
        return this.offName;
    }

    public Name getOnName() {
        return this.onName;
    }

    public Name getSelectedName() {
        return this.selectedName;
    }

    public void setSelectedName(Name selectedName) {
        this.selectedName = selectedName;
    }

    public AppearanceState getSelectedAppearanceState() {
        AppearanceState state = this.appearance.get(this.selectedName);
        return state;
    }

    public AppearanceState getAppearanceState(Name name) {
        AppearanceState state = this.appearance.get(name);
        return state;
    }

    protected void updateAppearanceDictionary(HashMap<Object, Object> entries) {
        entries.put(Annotation.APPEARANCE_STATE_KEY, this.selectedName);
    }
}

