/*
 * Decompiled with CFR 0.152.
 */
package com.topaz.sigplus.util;

public class SigPlusMD5
implements Cloneable {
    private long count;
    private static final int HASH_LENGTH = 16;
    private static final int DATA_LENGTH = 64;
    private int[] data;
    private int[] digest;
    private byte[] tmp;

    public SigPlusMD5() {
        this.java_init();
        this.java_reset();
    }

    private SigPlusMD5(SigPlusMD5 md) {
        this();
        this.data = (int[])md.data.clone();
        this.digest = (int[])md.digest.clone();
        this.tmp = (byte[])md.tmp.clone();
    }

    protected long bitcount() {
        return this.count * 8L;
    }

    private static void byte2int(byte[] src, int srcOffset, int[] dst, int dstOffset, int length) {
        while (length-- > 0) {
            dst[dstOffset++] = src[srcOffset++] & 0xFF | (src[srcOffset++] & 0xFF) << 8 | (src[srcOffset++] & 0xFF) << 16 | (src[srcOffset++] & 0xFF) << 24;
        }
    }

    public Object clone() {
        return new SigPlusMD5(this);
    }

    protected static int F(int x, int y, int z) {
        return z ^ x & (y ^ z);
    }

    protected static int FF(int a, int b, int c, int d, int k, int s, int t) {
        a += k + t + SigPlusMD5.F(b, c, d);
        a = a << s | a >>> -s;
        return a + b;
    }

    protected static int G(int x, int y, int z) {
        return y ^ z & (x ^ y);
    }

    protected static int GG(int a, int b, int c, int d, int k, int s, int t) {
        a += k + t + SigPlusMD5.G(b, c, d);
        a = a << s | a >>> -s;
        return a + b;
    }

    protected static int H(int x, int y, int z) {
        return x ^ y ^ z;
    }

    protected static int HH(int a, int b, int c, int d, int k, int s, int t) {
        a += k + t + SigPlusMD5.H(b, c, d);
        a = a << s | a >>> -s;
        return a + b;
    }

    protected static int I(int x, int y, int z) {
        return y ^ (x | ~z);
    }

    protected static int II(int a, int b, int c, int d, int k, int s, int t) {
        a += k + t + SigPlusMD5.I(b, c, d);
        a = a << s | a >>> -s;
        return a + b;
    }

    public byte[] java_digest(byte[] in, int pos) {
        if (pos != 0) {
            System.arraycopy(in, 0, this.tmp, 0, pos);
        }
        this.tmp[pos++] = -128;
        if (pos > 56) {
            while (pos < 64) {
                this.tmp[pos++] = 0;
            }
            SigPlusMD5.byte2int(this.tmp, 0, this.data, 0, 16);
            this.transform(this.data);
            pos = 0;
        }
        while (pos < 56) {
            this.tmp[pos++] = 0;
        }
        SigPlusMD5.byte2int(this.tmp, 0, this.data, 0, 14);
        long bc = this.bitcount();
        this.data[14] = (int)bc;
        this.data[15] = (int)(bc >>> 32);
        this.transform(this.data);
        byte[] buf = new byte[16];
        int off = 0;
        int i = 0;
        while (i < 4) {
            int d = this.digest[i];
            buf[off++] = (byte)d;
            buf[off++] = (byte)(d >>> 8);
            buf[off++] = (byte)(d >>> 16);
            buf[off++] = (byte)(d >>> 24);
            ++i;
        }
        return buf;
    }

    private void java_init() {
        this.digest = new int[4];
        this.data = new int[16];
        this.tmp = new byte[64];
    }

    public void java_reset() {
        this.digest[0] = 1732584193;
        this.digest[1] = -271733879;
        this.digest[2] = -1732584194;
        this.digest[3] = 271733878;
    }

    public void java_transform(byte[] in) {
        SigPlusMD5.byte2int(in, 0, this.data, 0, 16);
        this.transform(this.data);
    }

    protected void transform(int[] M) {
        int a = this.digest[0];
        int b = this.digest[1];
        int c = this.digest[2];
        int d = this.digest[3];
        a = SigPlusMD5.FF(a, b, c, d, M[0], 7, -680876936);
        d = SigPlusMD5.FF(d, a, b, c, M[1], 12, -389564586);
        c = SigPlusMD5.FF(c, d, a, b, M[2], 17, 606105819);
        b = SigPlusMD5.FF(b, c, d, a, M[3], 22, -1044525330);
        a = SigPlusMD5.FF(a, b, c, d, M[4], 7, -176418897);
        d = SigPlusMD5.FF(d, a, b, c, M[5], 12, 1200080426);
        c = SigPlusMD5.FF(c, d, a, b, M[6], 17, -1473231341);
        b = SigPlusMD5.FF(b, c, d, a, M[7], 22, -45705983);
        a = SigPlusMD5.FF(a, b, c, d, M[8], 7, 1770035416);
        d = SigPlusMD5.FF(d, a, b, c, M[9], 12, -1958414417);
        c = SigPlusMD5.FF(c, d, a, b, M[10], 17, -42063);
        b = SigPlusMD5.FF(b, c, d, a, M[11], 22, -1990404162);
        a = SigPlusMD5.FF(a, b, c, d, M[12], 7, 1804603682);
        d = SigPlusMD5.FF(d, a, b, c, M[13], 12, -40341101);
        c = SigPlusMD5.FF(c, d, a, b, M[14], 17, -1502002290);
        b = SigPlusMD5.FF(b, c, d, a, M[15], 22, 1236535329);
        a = SigPlusMD5.GG(a, b, c, d, M[1], 5, -165796510);
        d = SigPlusMD5.GG(d, a, b, c, M[6], 9, -1069501632);
        c = SigPlusMD5.GG(c, d, a, b, M[11], 14, 643717713);
        b = SigPlusMD5.GG(b, c, d, a, M[0], 20, -373897302);
        a = SigPlusMD5.GG(a, b, c, d, M[5], 5, -701558691);
        d = SigPlusMD5.GG(d, a, b, c, M[10], 9, 38016083);
        c = SigPlusMD5.GG(c, d, a, b, M[15], 14, -660478335);
        b = SigPlusMD5.GG(b, c, d, a, M[4], 20, -405537848);
        a = SigPlusMD5.GG(a, b, c, d, M[9], 5, 568446438);
        d = SigPlusMD5.GG(d, a, b, c, M[14], 9, -1019803690);
        c = SigPlusMD5.GG(c, d, a, b, M[3], 14, -187363961);
        b = SigPlusMD5.GG(b, c, d, a, M[8], 20, 1163531501);
        a = SigPlusMD5.GG(a, b, c, d, M[13], 5, -1444681467);
        d = SigPlusMD5.GG(d, a, b, c, M[2], 9, -51403784);
        c = SigPlusMD5.GG(c, d, a, b, M[7], 14, 1735328473);
        b = SigPlusMD5.GG(b, c, d, a, M[12], 20, -1926607734);
        a = SigPlusMD5.HH(a, b, c, d, M[5], 4, -378558);
        d = SigPlusMD5.HH(d, a, b, c, M[8], 11, -2022574463);
        c = SigPlusMD5.HH(c, d, a, b, M[11], 16, 1839030562);
        b = SigPlusMD5.HH(b, c, d, a, M[14], 23, -35309556);
        a = SigPlusMD5.HH(a, b, c, d, M[1], 4, -1530992060);
        d = SigPlusMD5.HH(d, a, b, c, M[4], 11, 1272893353);
        c = SigPlusMD5.HH(c, d, a, b, M[7], 16, -155497632);
        b = SigPlusMD5.HH(b, c, d, a, M[10], 23, -1094730640);
        a = SigPlusMD5.HH(a, b, c, d, M[13], 4, 681279174);
        d = SigPlusMD5.HH(d, a, b, c, M[0], 11, -358537222);
        c = SigPlusMD5.HH(c, d, a, b, M[3], 16, -722521979);
        b = SigPlusMD5.HH(b, c, d, a, M[6], 23, 76029189);
        a = SigPlusMD5.HH(a, b, c, d, M[9], 4, -640364487);
        d = SigPlusMD5.HH(d, a, b, c, M[12], 11, -421815835);
        c = SigPlusMD5.HH(c, d, a, b, M[15], 16, 530742520);
        b = SigPlusMD5.HH(b, c, d, a, M[2], 23, -995338651);
        a = SigPlusMD5.II(a, b, c, d, M[0], 6, -198630844);
        d = SigPlusMD5.II(d, a, b, c, M[7], 10, 1126891415);
        c = SigPlusMD5.II(c, d, a, b, M[14], 15, -1416354905);
        b = SigPlusMD5.II(b, c, d, a, M[5], 21, -57434055);
        a = SigPlusMD5.II(a, b, c, d, M[12], 6, 1700485571);
        d = SigPlusMD5.II(d, a, b, c, M[3], 10, -1894986606);
        c = SigPlusMD5.II(c, d, a, b, M[10], 15, -1051523);
        b = SigPlusMD5.II(b, c, d, a, M[1], 21, -2054922799);
        a = SigPlusMD5.II(a, b, c, d, M[8], 6, 1873313359);
        d = SigPlusMD5.II(d, a, b, c, M[15], 10, -30611744);
        c = SigPlusMD5.II(c, d, a, b, M[6], 15, -1560198380);
        b = SigPlusMD5.II(b, c, d, a, M[13], 21, 1309151649);
        a = SigPlusMD5.II(a, b, c, d, M[4], 6, -145523070);
        d = SigPlusMD5.II(d, a, b, c, M[11], 10, -1120210379);
        c = SigPlusMD5.II(c, d, a, b, M[2], 15, 718787259);
        b = SigPlusMD5.II(b, c, d, a, M[9], 21, -343485551);
        this.digest[0] = this.digest[0] + a;
        this.digest[1] = this.digest[1] + b;
        this.digest[2] = this.digest[2] + c;
        this.digest[3] = this.digest[3] + d;
    }
}

