/*
 * Decompiled with CFR 0.152.
 */
package com.topaz.sigplus.util;

import com.topaz.sigplus.util.DES;
import com.topaz.sigplus.util.MD5;
import com.topaz.sigplus.util.SAFER;
import com.topaz.sigplus.util.SigDataType;
import com.topaz.sigplus.util.SigDrawParameters;
import com.topaz.sigplus.util.SigInfo;
import com.topaz.sigplus.util.SigInputStream;
import com.topaz.sigplus.util.SigOutputStream;
import com.topaz.sigplus.util.SigWriter;
import java.io.FileInputStream;
import java.io.IOException;

public class SigCrypt {
    private static final int MaxSigKeySize = 64;
    private static final int Md5HashSize = 16;
    private static final int EncryptionModeNone = 0;
    private static final int EncryptionModeDES = 1;
    private static final int EncryptionModeSafer = 2;
    private static final int TopazEncryptionTag = -1;
    private transient MD5 hasher = new MD5();
    private transient byte[] autoKeyHash;
    private transient byte[] sigKeyData = new byte[64];
    private transient int sigKeyDataLen = 8;
    private transient int encryptionMode = 0;
    private static final int EncryptionModeSaferW = 3;

    public byte[] addEncHeader(byte[] inBuffer, int receipt) {
        byte[] outBuffer = new byte[inBuffer.length + 8];
        int i = 0;
        while (i < 4) {
            outBuffer[i] = -1;
            ++i;
        }
        outBuffer[4] = (byte)(receipt & 0xFF);
        outBuffer[5] = (byte)(receipt >> 8 & 0xFF);
        outBuffer[6] = (byte)(receipt >> 16 & 0xFF);
        outBuffer[7] = (byte)(receipt >> 24 & 0xFF);
        i = 0;
        while (i < inBuffer.length) {
            outBuffer[i + 8] = inBuffer[i];
            ++i;
        }
        return outBuffer;
    }

    public byte[] calcHashForFileBuffer(byte[] buffer) {
        int i;
        byte[] blockBuffer = new byte[512];
        SigInputStream inStr = new SigInputStream(buffer);
        byte[] hashVal = new byte[16];
        while ((i = inStr.readBinaryByteBuffer(blockBuffer, 512)) != 0) {
            MD5 h = new MD5();
            h.engineReset();
            int j = 0;
            while (j < i) {
                h.engineUpdate(blockBuffer[j]);
                ++j;
            }
            hashVal = h.engineDigest();
        }
        return hashVal;
    }

    public int calcReceipt(byte[] buffer) {
        byte[] hash = this.calcHashForFileBuffer(buffer);
        return this.convertHashToReceipt(hash);
    }

    public int convertHashToReceipt(byte[] hash) {
        int receipt = 0;
        int val = hash[0] ^ hash[4] ^ hash[8] ^ hash[12];
        receipt = val &= 0xFF;
        val = hash[1] ^ hash[5] ^ hash[9] ^ hash[13];
        receipt <<= 8;
        receipt |= (val &= 0xFF);
        val = hash[2] ^ hash[6] ^ hash[10] ^ hash[14];
        receipt <<= 8;
        receipt |= (val &= 0xFF);
        val = hash[3] ^ hash[7] ^ hash[11] ^ hash[15];
        receipt <<= 8;
        return receipt |= (val &= 0xFF);
    }

    public void copySigStream() {
    }

    public byte[] decryptBuffer(byte[] inBuffer) {
        if (inBuffer.length < 8) {
            return null;
        }
        byte[] decBuffer = new byte[inBuffer.length - 8];
        if (this.encryptionMode == 0) {
            return inBuffer;
        }
        if (!this.isEncrypted(inBuffer)) {
            return null;
        }
        int fileReceipt = this.stripEncHeader(inBuffer, decBuffer);
        byte[] key = this.make40BitKey(this.sigKeyData);
        byte[] finalBuffer = this.encryptionMode == 1 ? this.desDecryptBuffer(key, decBuffer) : this.saferDecryptBuffer(key, decBuffer);
        int newReceipt = this.calcReceipt(finalBuffer);
        if (newReceipt != fileReceipt) {
            return null;
        }
        return finalBuffer;
    }

    public byte[] desDecryptBuffer(byte[] key, byte[] inBuffer) {
        DES decryptor = new DES();
        SigInputStream inStream = new SigInputStream(inBuffer);
        SigOutputStream outStream = new SigOutputStream();
        byte[] inBlock = new byte[8];
        byte[] outBlock = new byte[8];
        int numBlocks = inStream.readBinaryInt();
        int lastFill = inStream.readBinaryInt();
        decryptor.engineInitDecrypt(key);
        int i = 0;
        while (i < numBlocks) {
            int j = 0;
            while (j < 8) {
                inBlock[j] = (byte)inStream.readBinaryByte();
                ++j;
            }
            decryptor.des(inBlock, 0, outBlock, 0, false);
            if (i < numBlocks - 1) {
                j = 0;
                while (j < 8) {
                    outStream.writeBinaryByte(outBlock[j]);
                    ++j;
                }
            } else {
                j = 0;
                while (j < 8 - lastFill) {
                    outStream.writeBinaryByte(outBlock[j]);
                    ++j;
                }
            }
            ++i;
        }
        return outStream.toByteArray();
    }

    public byte[] desEncryptBuffer(byte[] key, byte[] inBuffer) {
        DES encryptor = new DES();
        SigOutputStream outStream = new SigOutputStream();
        byte[] inBlock = new byte[8];
        byte[] outBlock = new byte[8];
        int inPtr = 0;
        int numBlocks = (inBuffer.length + 7) / 8;
        int lastFill = numBlocks * 8 - inBuffer.length;
        encryptor.engineInitEncrypt(key);
        outStream.writeBinaryInt(numBlocks);
        outStream.writeBinaryInt(lastFill);
        int i = 0;
        while (i < numBlocks) {
            int j = 0;
            while (j < 8) {
                inBlock[j] = inPtr < inBuffer.length ? inBuffer[inPtr++] : (byte)0;
                ++j;
            }
            encryptor.des(inBlock, 0, outBlock, 0, true);
            j = 0;
            while (j < 8) {
                outStream.writeBinaryByte(outBlock[j]);
                ++j;
            }
            ++i;
        }
        return outStream.toByteArray();
    }

    public byte[] encryptBuffer(byte[] inBuffer) {
        if (this.encryptionMode == 0) {
            return inBuffer;
        }
        byte[] key = this.make40BitKey(this.sigKeyData);
        byte[] encBuffer = this.encryptionMode == 1 ? this.desEncryptBuffer(key, inBuffer) : this.saferEncryptBuffer(key, inBuffer);
        byte[] finalBuffer = this.addEncHeader(encBuffer, this.calcReceipt(inBuffer));
        return finalBuffer;
    }

    private int fromHex(char hexChar) {
        if (hexChar >= '0' && hexChar <= '9') {
            return hexChar - 48;
        }
        if (hexChar >= 'A' && hexChar <= 'F') {
            return hexChar - 65 + 10;
        }
        if (hexChar >= 'a' && hexChar <= 'f') {
            return hexChar - 97 + 10;
        }
        return 0;
    }

    public int getEncryptionMode() {
        return this.encryptionMode;
    }

    public int getKeyReceipt() {
        byte[] buffer = new byte[16];
        int len = this.sigKeyDataLen > 16 ? 16 : this.sigKeyDataLen;
        int i = 0;
        while (i < len) {
            buffer[i] = this.sigKeyData[i];
            ++i;
        }
        return this.convertHashToReceipt(buffer);
    }

    public String getKeyReceiptAscii() {
        String str = "";
        str = String.valueOf(str) + this.getKeyReceipt();
        return str;
    }

    public String getKeyString() {
        String str = "";
        int i = 0;
        while (i < this.sigKeyDataLen) {
            str = String.valueOf(str) + this.toHex(this.sigKeyData[i] >> 4 & 0xF);
            str = String.valueOf(str) + this.toHex(this.sigKeyData[i] & 0xF);
            ++i;
        }
        return str;
    }

    public int getSigReceipt(SigDataType sig, SigDrawParameters displayParams, SigDrawParameters imageParams, int compressionMode) {
        SigInfo info = new SigInfo();
        int pnts = sig.getSigData(info);
        pnts = info.getNumPoints();
        if (pnts == 0) {
            return 0;
        }
        int oldEncryptionMode = this.encryptionMode;
        this.encryptionMode = 0;
        SigWriter writer = new SigWriter(compressionMode, this);
        byte[] buffer = writer.writeSigToByteArray(sig, displayParams, imageParams);
        int receipt = this.calcReceipt(buffer);
        this.encryptionMode = oldEncryptionMode;
        return receipt;
    }

    public String getSigReceiptAscii(SigDataType sig, SigDrawParameters displayParams, SigDrawParameters imageParams, int compressionMode) {
        String str = "";
        str = String.valueOf(str) + this.getSigReceipt(sig, displayParams, imageParams, compressionMode);
        return str;
    }

    public boolean isEncrypted(byte[] buffer) {
        byte b3 = buffer[3];
        byte b2 = buffer[2];
        byte b1 = buffer[1];
        byte b0 = buffer[0];
        int value = b3 << 24 | b2 << 16 | b1 << 8 | b0;
        return value == -1;
    }

    public byte[] make40BitKey(byte[] source) {
        byte[] shortKey = new byte[8];
        int i = 0;
        while (i < 8) {
            int tmp = source[i];
            shortKey[i] = (byte)(tmp &= 0x1F);
            ++i;
        }
        return shortKey;
    }

    public byte[] saferDecryptBuffer(byte[] key, byte[] inBuffer) {
        SAFER decryptor = new SAFER();
        SigInputStream inStream = new SigInputStream(inBuffer);
        SigOutputStream outStream = new SigOutputStream();
        byte[] inBlock = new byte[8];
        byte[] outBlock = new byte[8];
        int numBlocks = inStream.readBinaryInt();
        int lastFill = inStream.readBinaryInt();
        if (this.encryptionMode == 2) {
            decryptor.engineInitDecrypt(key, false);
        } else {
            decryptor.engineInitDecrypt(key, true);
        }
        int i = 0;
        while (i < numBlocks) {
            int j = 0;
            while (j < 8) {
                inBlock[j] = (byte)inStream.readBinaryByte();
                ++j;
            }
            decryptor.blockDecrypt(inBlock, 0, outBlock, 0);
            if (i < numBlocks - 1) {
                j = 0;
                while (j < 8) {
                    outStream.writeBinaryByte(outBlock[j]);
                    ++j;
                }
            } else {
                j = 0;
                while (j < 8 - lastFill) {
                    outStream.writeBinaryByte(outBlock[j]);
                    ++j;
                }
            }
            ++i;
        }
        return outStream.toByteArray();
    }

    public byte[] saferEncryptBuffer(byte[] key, byte[] inBuffer) {
        SAFER encryptor = new SAFER();
        SigOutputStream outStream = new SigOutputStream();
        byte[] inBlock = new byte[8];
        byte[] outBlock = new byte[8];
        int inPtr = 0;
        int numBlocks = (inBuffer.length + 7) / 8;
        int lastFill = numBlocks * 8 - inBuffer.length;
        if (this.encryptionMode == 2) {
            encryptor.engineInitEncrypt(key, false);
        } else {
            encryptor.engineInitEncrypt(key, true);
        }
        outStream.writeBinaryInt(numBlocks);
        outStream.writeBinaryInt(lastFill);
        int i = 0;
        while (i < numBlocks) {
            int j = 0;
            while (j < 8) {
                inBlock[j] = inPtr < inBuffer.length ? inBuffer[inPtr++] : (byte)0;
                ++j;
            }
            encryptor.blockEncrypt(inBlock, 0, outBlock, 0);
            j = 0;
            while (j < 8) {
                outStream.writeBinaryByte(outBlock[j]);
                ++j;
            }
            ++i;
        }
        return outStream.toByteArray();
    }

    public int stripEncHeader(byte[] inBuffer, byte[] outBuffer) {
        byte b0 = inBuffer[4];
        byte b1 = inBuffer[5];
        byte b2 = inBuffer[6];
        byte b3 = inBuffer[7];
        int receipt = b3 & 0xFF;
        receipt <<= 8;
        receipt |= b2 & 0xFF;
        receipt <<= 8;
        receipt |= b1 & 0xFF;
        receipt <<= 8;
        receipt |= b0 & 0xFF;
        int i = 0;
        while (i < inBuffer.length - 8) {
            outBuffer[i] = inBuffer[i + 8];
            ++i;
        }
        return receipt;
    }

    private char toHex(int hexInt) {
        if (hexInt < 10) {
            int returnChar = (hexInt & 0xF) + 48;
            return (char)returnChar;
        }
        int returnChar = (hexInt & 0xF) - 10 + 65;
        return (char)returnChar;
    }

    public void autoKeyAddData(byte[] autoData, SigDataType sig) {
        if (!this.changeKeyAllowed(sig)) {
            return;
        }
        int j = 0;
        while (j < autoData.length) {
            this.hasher.engineUpdate(autoData[j]);
            ++j;
        }
    }

    public void autoKeyFinish(SigDataType sig) {
        if (!this.changeKeyAllowed(sig)) {
            return;
        }
        this.autoKeyHash = this.hasher.engineDigest();
        int i = 0;
        while (i < 16) {
            this.sigKeyData[i] = this.autoKeyHash[i];
            ++i;
        }
        this.sigKeyDataLen = 16;
    }

    public void autoKeyFromFile(String fileName, SigDataType sig) {
        if (!this.changeKeyAllowed(sig)) {
            return;
        }
        try {
            FileInputStream file = new FileInputStream(fileName);
            byte[] buffer = new byte[file.available()];
            file.read(buffer);
            file.close();
            int j = 0;
            while (j < buffer.length) {
                this.hasher.engineUpdate(buffer[j]);
                ++j;
            }
            this.autoKeyHash = this.hasher.engineDigest();
            j = 0;
            while (j < 16) {
                this.sigKeyData[j] = this.autoKeyHash[j];
                ++j;
            }
            this.sigKeyDataLen = 16;
            return;
        }
        catch (IOException e) {
            return;
        }
    }

    public void autoKeyStart(SigDataType sig) {
        if (!this.changeKeyAllowed(sig)) {
            return;
        }
        this.hasher.engineReset();
    }

    public boolean changeDataAllowed(SigDataType sig) {
        SigInfo info = new SigInfo();
        int pnts = sig.getSigData(info);
        pnts = info.getNumPoints();
        return this.encryptionMode <= 2 || pnts == 0;
    }

    public boolean changeKeyAllowed(SigDataType sig) {
        SigInfo info = new SigInfo();
        int pnts = sig.getSigData(info);
        pnts = info.getNumPoints();
        return this.encryptionMode <= 1 || pnts == 0;
    }

    public void setAutoKeyData(String buffer, SigDataType sig) {
        byte[] byteBuffer = buffer.getBytes();
        if (!this.changeKeyAllowed(sig)) {
            return;
        }
        int j = 0;
        while (j < buffer.length()) {
            this.hasher.engineUpdate(byteBuffer[j]);
            ++j;
        }
    }

    public void setEncryptionMode(int newEncryptionMode, SigDataType sig) {
        SigInfo info = new SigInfo();
        int pnts = sig.getSigData(info);
        pnts = info.getNumPoints();
        if (newEncryptionMode != 3 && this.encryptionMode > 1 && pnts != 0) {
            return;
        }
        if (newEncryptionMode >= 0 && newEncryptionMode <= 3) {
            this.encryptionMode = newEncryptionMode;
        }
    }

    public void setKeyString(String newKey, SigDataType sig) {
        int j = 0;
        if (!this.changeKeyAllowed(sig)) {
            return;
        }
        int i = 0;
        while (i < newKey.length()) {
            int highNib = this.fromHex(newKey.charAt(i));
            int lowNib = this.fromHex(newKey.charAt(i + 1));
            int value = highNib << 4;
            this.sigKeyData[j++] = (byte)(value += lowNib);
            i += 2;
        }
        this.sigKeyDataLen = newKey.length() / 2;
    }
}

